package uml3d.visual;
/**UmlWorld holds some SimpleBoxes which are connected by some SimpleConnection
 *in a Branchgroup. When SimpleBoxes are added, a Branchgroup is wrapped around.
  *@author Oliver Radfelder
  */
import javax.media.j3d.*;
import javax.vecmath.*;

public class UmlWorld
{    
    BranchGroup objRoot;
    public UmlWorld()
    {
	objRoot = new BranchGroup();
	objRoot.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
	objRoot.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
	objRoot.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
	

    }
    /**add n directly into objRoot use only before this the wrapping canvas
     *has been made alive
     */
    public void addChild(Node n)
    {
	objRoot.addChild(n);
    }
    
    /**adds @param1 into objRoot after wrapping in a Branchgroup. can be
     * uses even after the canvas has been made alive
     */
    public void add(TransformGroup tg)
    {
	BranchGroup b=new BranchGroup();
	b.addChild(tg);
	objRoot.addChild(b);
    }
    public void add(Node n)
    {
	BranchGroup b=new BranchGroup();
	b.addChild(n);
	objRoot.addChild(b);
    }

    public void add(SimpleBox simpleBox)
    {
	BranchGroup b=new BranchGroup();
	b.addChild(simpleBox);
	objRoot.addChild(b);
    }

    public void connect(SimpleBox b1,SimpleBox b2,SimpleConnection sc)
    {
	SimpleConnectionBehavior scb=new SimpleConnectionBehavior(b1,b2,sc);
	scb.setSchedulingBounds(new BoundingSphere());
	BranchGroup bbox=new BranchGroup();
	bbox.addChild(scb);
        objRoot.addChild(bbox);


    }
	  
    public void moveBoxAlongPath(SimpleBox box,Point3f[] path)
    {
	float[] knots=new float[path.length];
	for(int i=0;i<path.length;++i)
	    {knots[i]=(float)(i*(1f/((float)path.length-1)));
	    System.out.println(knots[i]);
	    }
	Alpha alpha=new Alpha(-1,10000);
	PositionPathInterpolator interpolator=
	    new PositionPathInterpolator(alpha,
					 box,
					 new Transform3D(),
					 knots,
					 path
					 );
	BoundingSphere stdBoundingSphere=new BoundingSphere();

	interpolator.setSchedulingBounds(stdBoundingSphere);
	add(interpolator);	
	
    }
	

}
