package uml3d.visual;
/**
  *@author Oliver Radfelder
  */
import javax.media.j3d.*;
import javax.vecmath.*;

import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.behaviors.picking.*;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
/**UmlCanvas can be uses as Canvas3D, but has also a SimpleUniverse which holds
 * a UmlWorld. KeyNavigationBehavior, BoxPicking and a simple Lightmodel is added
 * during contruction. Afterwards, the UmlWorld can be retrieved to add Boxes
 * or connections
  *@author Oliver Radfelder
  */
public class UmlCanvas extends Canvas3D
{    
    private UmlWorld umlWorld;
    
    public UmlCanvas()
    {
	super(null);
	umlWorld=new UmlWorld();
	//SimpleUniverse is created and viewed from the canvas
	SimpleUniverse u = new SimpleUniverse(this);

	//The simple Behavior, provided by KeyNavBehavior is attached to 
	//the top level Branchgroup
	createBehavior(u);
	//appropriate lights must be added
	setLights();
	//the toplevel BranchGraph must be added to the Universe
	u.addBranchGraph(umlWorld.objRoot);
	
    }
    public UmlWorld getUmlWorld(){return umlWorld;}
    private void createBehavior(SimpleUniverse su)
    {
	//behavior for the ViewingPlatform
	TransformGroup vpTrans=su.getViewingPlatform().getViewPlatformTransform();
	Transform3D translate=new Transform3D();
	vpTrans.setTransform(translate);
	KeyNavigatorBehavior knb=new KeyNavigatorBehavior(vpTrans);
	knb.setSchedulingBounds(new BoundingSphere(new Point3d(),10000.0));
	umlWorld.addChild(knb);

	//picking and translating
	BoundingSphere bounds= new BoundingSphere(new Point3d(0.0,0.0,0.0), 10000.0);
	PickTranslateBehavior translatebehavior = 
	    new PickTranslateBehavior(umlWorld.objRoot, 
				      this, 
				      bounds,PickObject.USE_BOUNDS);
	umlWorld.addChild(translatebehavior);
    
    }
    private void setLights()
    {
	BoundingSphere lightbounds =
	    new BoundingSphere(new Point3d(0.0,0.0,0.0), 1000.0);

	//direct light
	DirectionalLight lgt1 = new DirectionalLight();
	//	 new DirectionalLight(new Color3f(0.1f, 0.1f, 0.1f),
	//	 new Vector3f(-0.5f, -0.5f, -0.5f));
	lgt1.setInfluencingBounds(lightbounds);
	umlWorld.addChild(lgt1);

	//ambient light
	Color3f alColor = new Color3f(0.9f, 0.9f, 0.9f);
	AmbientLight aLgt = new AmbientLight(alColor);
	aLgt.setInfluencingBounds(lightbounds);
	umlWorld.addChild(aLgt);

    }

	

}
