package uml3d.visual;

import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.behaviors.picking.*;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;

import java.applet.*;
import java.awt.*;
/**TestVisual creates a SimpleUniverse and a Scenegraph which the user can walk in.
  *@author Oliver Radfelder
  */
public class TestVisual extends Applet {
    //    Canvas3D canvas;
    BoundingSphere stdBoundingSphere;
    //UmlWorld umlWorld;

    public void createBehaviour(SimpleUniverse su, BranchGroup branchGroup,Canvas3D canvas)
    {
	//behavior for the ViewingPlatform
	TransformGroup vpTrans=su.getViewingPlatform().getViewPlatformTransform();
	Transform3D translate=new Transform3D();
	vpTrans.setTransform(translate);
	KeyNavigatorBehavior knb=new KeyNavigatorBehavior(vpTrans);
	knb.setSchedulingBounds(new BoundingSphere(new Point3d(),10000.0));
	branchGroup.addChild(knb);

	//picking and translating
	BoundingSphere bounds= new BoundingSphere(new Point3d(0.0,0.0,0.0), 10000.0);
	PickTranslateBehavior translatebehavior = 
	    new PickTranslateBehavior(branchGroup, 
				      canvas, 
				      bounds,PickObject.USE_BOUNDS);
	branchGroup.addChild(translatebehavior);
    
    }
    public void setLights(BranchGroup branchGroup)
    {
	BoundingSphere lightbounds =
	    new BoundingSphere(new Point3d(0.0,0.0,0.0), 1000.0);

	//direct light
	DirectionalLight lgt1 = new DirectionalLight();
	    //	    new DirectionalLight(new Color3f(0.1f, 0.1f, 0.1f),
	    //		 new Vector3f(-0.5f, -0.5f, -0.5f));
	lgt1.setInfluencingBounds(lightbounds);
	branchGroup.addChild(lgt1);
	

	//ambient light
	Color3f alColor = new Color3f(0.9f, 0.9f, 0.9f);

	AmbientLight aLgt = new AmbientLight(alColor);
	aLgt.setInfluencingBounds(lightbounds);
	branchGroup.addChild(aLgt);

    }
    /*
    public PositionPathInterpolator addPositionPathInterpolator(int st,TransformGroup objTrans)
    {
	Point3f start=new Point3f(-2f,2f,-12f);
	Point3f or=new Point3f(2f,2f,+2f);
	Point3f ur=new Point3f(2f,-2f,-12);
	Point3f ul=new Point3f(-2f,-2f,2);
	Point3f[] path= {start,or,ur,ul,start};

	if(st==2)
	    {	
		Point3f[] p= {start,ul,ur,or,start};
		path=p;
	    }
	float[] knots={0.0f,0.25f,0.5f,0.75f,1.0f};
	Alpha alpha=new Alpha(-1,10000);
	PositionPathInterpolator interpolator=
	    new PositionPathInterpolator(alpha,
					 objTrans,
					 new Transform3D(),
					 knots,
					 path
					 );
	BoundingSphere stdBoundingSphere=new BoundingSphere();

	interpolator.setSchedulingBounds(stdBoundingSphere);
	umlWorld.add(interpolator);			 
	return interpolator;
    }
					 
    */

    public TestVisual()
    {
	//A UmlCanvas is placed in the center of the mainFrame
	setLayout(new BorderLayout());
	UmlCanvas canvas=new UmlCanvas();
	add("Center", canvas);

	
	UmlWorld umlWorld=canvas.getUmlWorld();
	

	//create 2 SimpleBoxes and add them
	SimpleBox simpleBox1=new SimpleBox();
	SimpleBox simpleBox2=new SimpleBox();
	//SimpleBox simpleBox3=new SimpleBox();

	umlWorld.add(simpleBox1);
	umlWorld.add(simpleBox2);
	//umlWorld.add(simpleBox3);


	

	SimpleConnection con1=new SimpleConnection();
	//SimpleConnection con2=new SimpleConnection();
	//SimpleConnection con3=new SimpleConnection();
	umlWorld.add(con1);
	//umlWorld.add(con2);
	//umlWorld.add(con3);
	umlWorld.connect(simpleBox1,simpleBox2,con1);
	//umlWorld.connect(simpleBox1,simpleBox3,con2);
	//umlWorld.connect(simpleBox2,simpleBox3,con3);

	simpleBox1.jumpTo(0,0,-8);
	simpleBox2.jumpTo(2f,0,-7.5f);
	//simpleBox3.jumpTo(2f,2,-7.5f);

	
	Point3f[] path= {new Point3f(-2f,2f,-12f),new Point3f(2f,2f,+2f),new Point3f(2f,-2f,-12),new Point3f(-2f,-2f,2),new Point3f(-2f,2f,-12f)};



	//umlWorld.moveBoxAlongPath(simpleBox1,path);


    }

    public static void main(String[] args) {
      TestVisual tv=new TestVisual();
      	MainFrame mf=new MainFrame(tv,1200, 900);
	mf.setBounds(0,0,1200,900);
    }
}

