package uml3d.visual;
import javax.media.j3d.*;
import javax.vecmath.*;

/**A SimpleShape is the anchestor of all Simplexxx. Thus, each heir
  * can be jumped to a position in space. Capabilities are set
  * properly and a static operation serves as a simple way to produce
  * standard apperance. 
  *@author Oliver Radfelder */

public class SimpleShape extends TransformGroup{ 
    /**Due to speed each graphical Object has its own Transform3D and Vector3f
     *to copy the new values in and move it straight to its new place
     */
    Transform3D transform3D=new Transform3D();
    Vector3f positionVector3f=new Vector3f();


    /** Constructor sets Capabilities
     */
    public SimpleShape()
    {
	setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
 	setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
	setCapability(TransformGroup.ENABLE_PICK_REPORTING);
    }
    /** moves the shape instantly to the position
     *  @param v determins the position
     */
    public void jumpTo(Vector3f v)
    {
	transform3D.set(v);
	setTransform(transform3D);
    }
 public void jumpTo(float x,float y, float z)
    {
	positionVector3f.x=x;
	positionVector3f.y=y;
	positionVector3f.z=z;
	transform3D.set(positionVector3f);
	setTransform(transform3D);
    }
 public Vector3f getTranslation()
    {
	getTransform(transform3D);
	transform3D.get(positionVector3f);
	return positionVector3f;
    }
    

  static Appearance initAppearance(float colr,float colg,float colb)
    {
	Material stdMaterial=new Material();
	stdMaterial.setEmissiveColor(0.0f,0,0);
	stdMaterial.setAmbientColor(colr,colg,colb);
	stdMaterial.setDiffuseColor(colr,colg,colb);
	stdMaterial.setSpecularColor(colr,colg,colb);
	
	//stdMaterial.setShininess(col);
	
	ColoringAttributes stdColoringAttributes=new ColoringAttributes();
	stdColoringAttributes.setColor(colr,colg,colb);
	Appearance appearance=new Appearance();

	appearance.setColoringAttributes(stdColoringAttributes);
	appearance.setMaterial(stdMaterial);
	 PolygonAttributes pa=new PolygonAttributes();
	 //pa.setPolygonMode(PolygonAttributes.POLYGON_LINE);
	 pa.setCullFace(PolygonAttributes.CULL_NONE);
	 appearance.setPolygonAttributes(pa);

	return appearance;
	
    }

}
