package uml3d.visual;
import javax.media.j3d.*;
import javax.vecmath.*;

import java.util.*;
/**A SimpleConnectionBehavior gets two SimpleBoxes and a SimpleConnection
 * Whenever one of the boxes changes its Transformation this behavior is waken up and
 * the SimpleConnection (or its successor) is adjusted to the new positions
 * SimpleConnectionBehavior should be kept simple, for there are some other Behaviros 
 * which should work similar on other components
  *@author Oliver Radfelder
  */
public class SimpleConnectionBehavior extends Behavior
{
    SimpleBox box1,box2;
    SimpleConnection connection;
    WakeupOr wuor;
    

    SimpleConnectionBehavior(SimpleBox b1,SimpleBox b2,SimpleConnection sc)
    {
	box1=b1;
	box2=b2;
	connection=sc;
    }
    
    public void initialize(){
	//wake up whenever either of the two boxes changes its translation
	WakeupCriterion[] wuc=new WakeupCriterion[2];
	wuc[0]=new WakeupOnTransformChange(box1);
	wuc[1]=new WakeupOnTransformChange(box2);
	wuor=new WakeupOr(wuc);
	adjust();
	this.wakeupOn(wuor);
    }    

    void adjust()
    {
	Vector3f box1intersect=box1.getIntersection(box2.getTranslation());
	Vector3f box2intersect=box2.getIntersection(box1.getTranslation());
	if((box1intersect!=null)&&(box2intersect!=null))
	    {
		Vector3f translation=box1.getTranslation();
		connection.put(translation,box1intersect,box2intersect);
	    }
    }
    public void processStimulus(Enumeration criteria){
	adjust();
	this.wakeupOn(wuor);
	
    }
}




