package uml3d.visual;
import javax.media.j3d.*;
import javax.vecmath.*;

/**A SimpleConnection is everything which can lay between two elements.
 * SimpleConnection itself is a cylinder with a starting point an end point
 * and a rotation point. The difference between start point and end point 
 * determines the lenngth. The rotation point is either the center of 
 * a SimpleBox of a point on a SimpleConnection. The position and the length
 * is determined by a behavior.
  *@author Oliver Radfelder
  */
public class SimpleConnection extends SimpleShape{
    public static Appearance stdAppearance;
    public static boolean init=false;
    //public static float colg=0.5f;

    Arrow shape;
 



    public SimpleConnection()
    {
	super();
	if(!init){
	    stdAppearance=initAppearance(0,0.5f,0);
	    PolygonAttributes pa=stdAppearance.getPolygonAttributes();
	    //pa.setPolygonMode(PolygonAttributes.POLYGON_LINE);
	}
	setShape();
	
	setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
 	setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
	setCapability(TransformGroup.ENABLE_PICK_REPORTING);

	

    }
    void setShape(){
	shape=new Arrow();
	shape.createGeometry();
	shape.setAppearance(stdAppearance);
	addChild(shape);
	
    }

    void put(Vector3f from,Vector3f intersection,Vector3f to)
    {

	// get the angle between arrow (points upwards from origin) and 
	// vector from from to to

	//Vector3f to
	//Vector3f v1=to; to.sub(from);
	Vector3f v1=new Vector3f(to); v1.sub(from);
	Vector3f v2=new Vector3f(0,1,0);

	float angle=v2.angle(v1);

	//rotation axis is the orthogonal of the resulting vector
	float rotz=-v1.x;
	float rotx=v1.z;
	AxisAngle4f aa=new AxisAngle4f(rotx,0,rotz,angle);


	transform3D.set(aa);
	transform3D.setTranslation(from);
	setTransform(transform3D);

	Point3f from3f=new Point3f(from);
	Point3f intersection3f=new Point3f(intersection);
	Point3f to3f=new Point3f(to);

	float start=from3f.distance(intersection3f);
	//shape.setStartingPoint(distance);
	float length=from3f.distance(to3f);
	shape.setStartAndLength(start,length);
	
	
    }



}
