package uml3d.visual;

//TransformGroup et.al
import javax.media.j3d.*;

//Box etc
import com.sun.j3d.utils.geometry.*;

import javax.vecmath.*;

/**SimpleBox is simply a Box with predefined color and size. It serves as 
  *the visual representation for classes, objects etc.
  *It is not a geometryNode, but it has a geometry which is inside
  *the transformGroup.
  *@author Oliver Radfelder
  */
public class SimpleBox extends SimpleShape
{
    
    public static Appearance stdAppearance;
    public static boolean init=false;
    public static float colr=0.5f;

    Box box; 
    Appearance appearance;

    float width=0.5f;
    float height=0.5f;
    float depth=0.5f;

    
    public SimpleBox()
    {
	super();
	if(!init)
	    {
		stdAppearance=initAppearance(0.5f,0,0);
		TransparencyAttributes ta=new TransparencyAttributes();
		ta.setTransparency(0.9f);
		ta.setTransparencyMode(TransparencyAttributes.NICEST);
		//stdAppearance.setTransparencyAttributes(ta);
	    }
	appearance=stdAppearance;
	box=new Box(width,height,depth,appearance);
	addChild(box);
	
    }

    public Point3f getPosition()
    {
	getTransform(transform3D);
	transform3D.get(positionVector3f);
	return new Point3f(positionVector3f);
    }
   


    private boolean between(float v0,float v1,float v2)
    {
	if((v0>v1)&&(v0<v2))return true;
	else return false;
    }

    public Vector3f getIntersection(Vector3f opposite)
    {
	//get current transformation into transform3D
	getTransform(transform3D);
	transform3D.get(positionVector3f);

	float xs,ys,zs;
	
	float bh=width;
	float hh=height;
	float th=depth;

	

	//bottom
	xs=positionVector3f.x;
	ys=positionVector3f.y-height;//intersection 
	zs=positionVector3f.z;
	float v=-((opposite.y-(ys))/(positionVector3f.y-opposite.y));
        float nx=opposite.x+v*(positionVector3f.x-opposite.x);
	float ny=opposite.y+v*(positionVector3f.y-opposite.y);
	float nz=opposite.z+v*(positionVector3f.z-opposite.z);
	if(between(nx,positionVector3f.x-width,positionVector3f.x+width)&&
	   between(nz,positionVector3f.z-depth,positionVector3f.z+depth)&&
	   (opposite.y<positionVector3f.y))
	    {
		return new Vector3f(nx,ny,nz);
	    }

	//top
	xs=positionVector3f.x;
	ys=positionVector3f.y+height;//intersection 
	zs=positionVector3f.z;
	v=-((opposite.y-(ys))/(positionVector3f.y-opposite.y));
        nx=opposite.x+v*(positionVector3f.x-opposite.x);
	ny=opposite.y+v*(positionVector3f.y-opposite.y);
	nz=opposite.z+v*(positionVector3f.z-opposite.z);
	if(between(nx,positionVector3f.x-width,positionVector3f.x+width)&&
	   between(nz,positionVector3f.z-depth,positionVector3f.z+depth)&&
	   (opposite.y>positionVector3f.y))
	    {
		return new Vector3f(nx,ny,nz);
	    }
	
	//front
	xs=positionVector3f.x;
	ys=positionVector3f.y;
	zs=positionVector3f.z+depth;//intersection 

	v=(-(zs-opposite.z)/(opposite.z-positionVector3f.z));
	nx=opposite.x+v*(positionVector3f.x-opposite.x);
	ny=opposite.y+v*(positionVector3f.y-opposite.y);
	nz=opposite.z+v*(positionVector3f.z-opposite.z);
	if(between(nx,positionVector3f.x-width,positionVector3f.x+width)&&
	   between(ny,positionVector3f.y-height,positionVector3f.y+height)&&
	   (positionVector3f.z<opposite.z))
	    { return new Vector3f(nx,ny,nz);;
	    }

	//back
	xs=positionVector3f.x;
	ys=positionVector3f.y;
	zs=positionVector3f.z-depth;//intersection 
	
	v=(-(zs-opposite.z)/(opposite.z-positionVector3f.z));
	nx=opposite.x+v*(positionVector3f.x-opposite.x);
	ny=opposite.y+v*(positionVector3f.y-opposite.y);
	nz=opposite.z+v*(positionVector3f.z-opposite.z);
	if(between(nx,positionVector3f.x-width,positionVector3f.x+bh)&&
	   between(ny,positionVector3f.y-height,positionVector3f.y+height)&&
	   (opposite.z<positionVector3f.z))
	    {
		return new Vector3f(nx,ny,nz);;
	    }

	//left
	xs=positionVector3f.x-width;//intersection 
	ys=positionVector3f.y;
	zs=positionVector3f.z;

	v=(-(xs-opposite.x)/(opposite.x-positionVector3f.x));
	nx=opposite.x+v*(positionVector3f.x-opposite.x);
	ny=opposite.y+v*(positionVector3f.y-opposite.y);
	nz=opposite.z+v*(positionVector3f.z-opposite.z);
	if(between(nz,positionVector3f.z-depth,positionVector3f.z+depth)&&
	   between(ny,positionVector3f.y-height,positionVector3f.y+height)&&
	   (opposite.x<positionVector3f.x))
	    {
		return new Vector3f(nx,ny,nz);;
	    }	
	//right
	xs=positionVector3f.x+width;//intersection 
	ys=positionVector3f.y;
	zs=positionVector3f.z;

	v=(-(xs-opposite.x)/(opposite.x-positionVector3f.x));
	nx=opposite.x+v*(positionVector3f.x-opposite.x);
	ny=opposite.y+v*(positionVector3f.y-opposite.y);
	nz=opposite.z+v*(positionVector3f.z-opposite.z);
	if(between(nz,positionVector3f.z-depth,positionVector3f.z+depth)&&
	   between(ny,positionVector3f.y-height,positionVector3f.y+height)&&
	   (opposite.x>positionVector3f.x))
	    {
		return new Vector3f(nx,ny,nz);;
	    }	

	return null;
    }
    




}
    



