package uml3d.visual;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.lang.Math.*;
import java.awt.*;


public class Cylinder2 extends Shape3D
{

    private Geometry geometry;
 
        /**
        * Constructs a Cylinder with 'n' quads (faces), 'w' width (diameter), 
        * 'h' height, centered at 'xpos', 'ypos', 'zpos',
        * and appearance 'cylinderAppearance'
        **/
    public  Cylinder2(Appearance cylinderAppearance) 
        {
	    int N=17;
	    Point3f coords[]=new Point3f[2*N];

	    int stripCounts[]={2*N+2};
	    float r=0.1f;
	    float w=0.4f;
	    int n;
	    double a;
	    float x,y,z;
	    int coordcount=0;
	    Vector3f norm=new Vector3f();
	    TriangleStripArray tsa=new TriangleStripArray(2*N+2,TriangleStripArray.COORDINATES|TriangleStripArray.NORMALS,stripCounts);
	    for(a=0,n=0;n<N;a=2.0*Math.PI/(N-1) * ++n)
		{
		    x=(float) (r*Math.cos(a));
		    z=(float) (r*Math.sin(a));
		    tsa.setCoordinate(coordcount,new Point3f(x,0,z));
		    norm.set(x,0,z);
		    norm.normalize();
		    tsa.setNormal(coordcount,norm);
		    tsa.setCoordinate(coordcount+1,new Point3f(x,0.3f,z));
		    tsa.setNormal(coordcount+1,norm);
		    coordcount+=2;
		}
	    //tsa.setCoordinates(0,coords);
	    geometry=tsa;
	    setGeometry(geometry);
	    setAppearance(cylinderAppearance);

		PolygonAttributes pa=new PolygonAttributes();
		//pa.setPolygonMode(PolygonAttributes.POLYGON_LINE);
		pa.setCullFace(PolygonAttributes.CULL_NONE);
		cylinderAppearance.setPolygonAttributes(pa);

		
	}


}
