package uml3d.visual;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.lang.Math.*;
import java.awt.*;


public class Cylinder extends Shape3D
{
    private float[] qverts;
    private float[] qtex;
    private float x, y, z, theta, t, num, 
	numcirc, calct, xn, yn, zn, mag;
    private int vertCount = 0;
    private int normalcount = 0;
    private Vector3f[] normals;
    private QuadArray cylinderGeometry;
    private Geometry geometry2;
 
        /**
        * Constructs a Cylinder with 'n' quads (faces), 'w' width (diameter), 
        * 'h' height, centered at 'xpos', 'ypos', 'zpos',
        * and appearance 'cylinderAppearance'
        **/
    public  Cylinder(int n, float w, float h, float xpos, 
                float ypos, float zpos, Appearance cylinderAppearance) 
        {
	  
                qverts = new float[12*(n+1)];
                qtex = new float[12*(n+1)];
                t = ((float) (2*Math.PI*(w/2))/n);
                theta = t/(w/2);
                numcirc = n;
		for (int i=0; i <= numcirc; i++)
		    {
                        //bottom points
                        x = (float) ((w/2)*Math.cos(theta*i));
                        z = (float) ((w/2)*Math.sin(theta*i));
                        qverts[vertCount]    = x;
                        vertCount++;
                        qverts[vertCount]    = 0;
                        vertCount++;          
                        qverts[vertCount]    = z;
                        vertCount++;
                           
                        i++;

                        x = (float) ((w/2)*Math.cos(theta*i));
                        z = (float) ((w/2)*Math.sin(theta*i));
                        qverts[vertCount]    = x;
                        vertCount++;
                        qverts[vertCount]    = 0;
                        vertCount++;          
                        qverts[vertCount]    = z;
                        vertCount++;

                        //top points
                        x = (float) ((w/2)*Math.cos(theta*i));
                        z = (float) ((w/2)*Math.sin(theta*i));
                        qverts[vertCount]    = x;
                        vertCount++;
			qverts[vertCount]    = 0+(h/2);
			//qverts[vertCount]    = 0;
                        vertCount++;          
                        qverts[vertCount]    = z;
                        vertCount++;

                        i--;

                        x = (float) ((w/2)*Math.cos(theta*i));
                        z = (float) ((w/2)*Math.sin(theta*i));
                        qverts[vertCount]    = x;
                        vertCount++;
                        qverts[vertCount]    = 0+(h/2);
                        vertCount++;          
                        qverts[vertCount]    = z;
                        vertCount++;
		    }

		cylinderGeometry = 
		    new QuadArray( vertCount/3,   
				   QuadArray.COORDINATES | QuadArray.NORMALS);

		cylinderGeometry.setCapability( QuadArray.ALLOW_COORDINATE_WRITE );
		cylinderGeometry.setCapability( QuadArray.ALLOW_COORDINATE_READ );
		cylinderGeometry.setCapability( QuadArray.ALLOW_NORMAL_WRITE );

                cylinderGeometry.setCoordinates( 0, qverts );
		setNormals();

		setGeometry(cylinderGeometry);
		setAppearance(cylinderAppearance);
		setCapability(Shape3D.ALLOW_GEOMETRY_READ);
		setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);

		PolygonAttributes pa=new PolygonAttributes();
		//pa.setPolygonMode(PolygonAttributes.POLYGON_LINE);
		pa.setCullFace(PolygonAttributes.CULL_NONE);
		cylinderAppearance.setPolygonAttributes(pa);

	       

		
	}

private void setNormals()
  {normalcount=0;
 normals = new Vector3f[vertCount/3];
                for (int s = 0; s < vertCount; s = s + 3)
                {    
                        Vector3f norm = new Vector3f(0.0f, 0.0f, 0.0f);
                        mag = qverts[s] * qverts[s] + qverts[s+1] * 
                                        qverts[s+1] + qverts[s+2] * qverts[s+2];
                        if (mag != 0.0) 
                        { 
                                mag = 1.0f / ((float) Math.sqrt(mag)); 
                                xn = qverts[s]*mag; 
                                yn = qverts[s+1]*mag; 
				yn=0;
                                zn = qverts[s+2]*mag;
                                norm = new Vector3f(xn, yn, zn);
                        }                       
                        normals[normalcount] = norm;
                        cylinderGeometry.setNormal(normalcount, norm);
                        normalcount++;
			
                }
  }
}
