package uml3d.visual;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.lang.Math.*;
import java.awt.*;


/**An Arrow is a Shape3D which consists of 5 layers. Each layer is a
 * strip where the lower circle is of radius r[i] and the upper
 * circles is of radius r[i+1]. Also, their height is determined by
 * h[i] and h[i+1]. Thus, all three forms can be constructed by
 * varying heights and radiuses.  The orientation is never
 * changed. This must be done by means of the wrapping TransformGroup.
 * Only the length varies by shrinking the third layer where usually
 * both radiuses are equal.  The Constructor does not do anything
 * meaningful. After creation, radiuses and heights can be set.
 * Afterwards createGeometry must be invoked to create and set the
 * real Geometry.  Normals are not set properly. (todo)
  *@author Oliver Radfelder */
public class Arrow extends Shape3D
{

    private TriangleStripArray geometry;
    int N=33;
    int layers=5;
    Point3f coords[]=new Point3f[5*(N+1)];
    Point3f newcoords[]=new Point3f[5*(N+1)];
    int stripCounts[]={N+1,N+1,N+1,N+1,N+1};
    //float[] r={0.001f,0.04f,0.05f,0.05f,0.04f,0.001f};
    //float[] h={0.0f,0.02f,0.05f,0.95f,0.98f,1f};
    float[] r={0.001f,0.04f,0.05f,0.05f,0.1f,0.001f};
    float[] h={0.0f,0.02f,0.05f,1.80f,1.80f,2f};

    int sg=0;

    public  Arrow() 
        {
	    setCapability(Shape3D.ALLOW_GEOMETRY_READ);
	    setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);


	}

    public void createGeometry()
    {
	int n;
	double a;
	float x1,z1,x2,z2;

	//counter to determine the current coordinate
	int coordcount=0;
	//holds the Normals (hope so)
	Vector3f norm=new Vector3f();
	
	//A TSA is a collection of strips (5), each consists of 18 vertices. 
	//Points 0,1,2,3,4,5 ...
	//means triangle (0,1,2)(1,2,3)(2,3,4)...
	TriangleStripArray tsa=
	    new TriangleStripArray(5*(N+1),
				   TriangleStripArray.COORDINATES|
				   TriangleStripArray.NORMALS|
				   TriangleStripArray.COLOR_3,
 				   stripCounts);
	tsa.setCapability(TriangleStripArray.ALLOW_COORDINATE_READ);
	tsa.setCapability(TriangleStripArray.ALLOW_COORDINATE_WRITE);
	tsa.setCapability(TriangleStripArray.ALLOW_COLOR_WRITE);
	//each of the 5 layers
	for(int i=0;i<layers;++i)
	    {
		//each cylinder disc has N/2 vertices. thus, vertex 0 and 1 has the same
		//angle but due to different radius and height difffernt x and y coordinates
		for(a=0,n=0;n<N;n+=2)
		    {
			a=2.0*Math.PI/(N-1) *n;
			//the layer's first radius
			x1=(float) (r[i]*Math.cos(a));
			z1=(float) (r[i]*Math.sin(a));
			//and the layer's second radius
			x2=(float) (r[i+1]*Math.cos(a));
			z2=(float) (r[i+1]*Math.sin(a));
			//tsa.setCoordinate(coordcount,new Point3f(x1,h[i],z1));
			coords[coordcount]=new Point3f(x1,h[i],z1);
			norm.set(x1,0,z1);
			if(i==0)norm.set(x1,-1,z1);
			norm.normalize();
			tsa.setNormal(coordcount,norm);
			tsa.setColor(coordcount,new Color3f(0,0,1));

			
			norm.set(x2,0,z2);
			if(i==layers-1)norm.set(x2,1,z2);
						
			//tsa.setCoordinate(coordcount+1,new Point3f(x2,h[i+1],z2));
			coords[coordcount+1]=new Point3f(x2,h[i+1],z2);
			tsa.setNormal(coordcount+1,norm);
			tsa.setColor(coordcount+1,new Color3f(0,0,1));
			coordcount+=2;
		    }
	    }
	geometry=tsa;
	//copy coordinates into newcoordinates
	//for there shall not be any changes to coords
	for(int i=0;i<coords.length;++i)
	    {
		newcoords[i]=new Point3f(coords[i]);
	    }
	tsa.setCoordinates(0,newcoords);
	
	setGeometry(geometry);
	

	}
    /**gets the distance from rotation point and intersection of the first box
     * whatever. Sets the first three layers z coordinate so that the first layer
     * has z=length;
     */
    public void setStartAndLength(float start,float length)
    {


	for(int i=0;i<(N+1)*2;++i)
	    {
		newcoords[i].y=coords[i].y+start;
	    }
	int max=(N+1)*2;
	for(int i=max;i<max+N+1;i+=2)
	    {
		newcoords[i].y=coords[i].y+start;
	    }

	for(int i=max+1;i<max+N+1;i+=2)
	    {
		newcoords[i].y=coords[i].y+length-h[5];
	    }
	max=(N+1)*3;
	for(int i=max;i<coords.length;++i)
	    {
		newcoords[i].y=coords[i].y+length-h[5];
	    }
	geometry.setCoordinates(0,newcoords);

    }
	


}
